<?php
function isValidCompanyEmail($email, $allowedDomains = ['wildnet.com'])
{
    $email = strtolower(trim($email));
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        return "Invalid email format.";
    }

    [$local, $domain] = explode('@', $email, 2);

    // Optional: handle IDN domains
    if (function_exists('idn_to_ascii')) {
        $ascii = idn_to_ascii($domain, 0, INTL_IDNA_VARIANT_UTS46);
        if ($ascii !== false) {
            $domain = $ascii;
        }
    }

    if (!in_array($domain, $allowedDomains, true)) {
        return "Only company emails (" . implode(', ', $allowedDomains) . ") are allowed.";
    }

    return true;
}

function generateRandomString($length = 6)
{
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomSring = "";
    for ($i = 0; $i < $length; $i++) {
        $randomSring .= $characters[random_int(0, $charactersLength - 1)];
    }
    return $randomSring;
}