<?php
// ini_set('session.gc_maxlifetime', 60); // 1 hour
// require_once 'config/session_init.php';
require_once 'config/session_check.php';
require_once 'config/config.php';
require_once 'includes/auth.php';
require_once 'classes/Employee.php';
require_once 'classes/Department.php';
require_once 'classes/Task.php';
// require_once 'classes/TaskCategory.php';

requireRole(['admin']);

$emp_id = $_SESSION['emp_id'];

$empObj = new Employee($conn);
$taskObj = new Task($conn);
// $taskCategoryObj = new TaskCategory($conn);

$deptObj = new Department($conn);
$departments = $deptObj->getDepartments();

$employee = $empObj->getEmployeeById($emp_id);
$allEmployees = $empObj->getAllEmployees();
$accountableEmployees = array_values(array_filter($allEmployees, fn($emp) => ($emp['role'] !== 'hod' && $emp['role'] !== 'admin')));
$repManagers = array_values(array_filter($allEmployees, fn($emp) => $emp['role'] == 'rm'));
// $tasks = $taskObj->getEmployeeTasks($emp_id);
// $taskCategories = $taskCategoryObj->getCategoriesByDept($employee['dept_id']);
// print_r($taskCategories);die;

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title>Home</title>
    <link rel="stylesheet" href="assets/css/index2.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" />
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/admin.css">
    <style>
        .tab-content {
            padding: 0;
        }

        .description-cell {
            max-width: 200px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            cursor: pointer;
        }

        .description-cell:hover {
            border: 2px solid yellow;
        }

        #desc-modal {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 9999;
        }

        #desc-modal-content {
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            position: relative;
        }

        #desc-modal-body {
            padding: 15px;
            min-width: 400px;
            max-width: 600px;
            max-height: 80vh;
            min-height: 200px;
            overflow-y: auto;
            font-size: .9rem;
        }

        #desc-modal-close {
            position: absolute;
            top: 10px;
            right: 12px;
            cursor: pointer;
            font-size: 25px;
            font-weight: bold;
        }
    </style>
</head>

<body>
    <!-- Header Dblist-->
    <header>
        <a href="dashboard-<?= $_SESSION['emp_role'] ?>.php">
            <div class="logo">
                <img src="assets/images/wnet-image.png" alt="WildNet logo">
            </div>
        </a>
        <div class="search-area">
            <h3 class="head">Hi <?= explode(' ', $employee['name'])[0] ?></h3> <!-- Show First Name -->
            <div class="actions">
                <!-- <label id="profile-label">
                    <i class="fa-solid fa-user"></i>
                    <button id="profile-toggle">
                        <i class="fa-solid fa-caret-down"></i>
                    </button>
                    <div id="profile-dropdown" class="profile-dropdown">
                        <a href="manage-profile.php" class="dropdown-item">My Profile</a>
                        <hr>
                        <a href="manage-profile.php" class="dropdown-item">Reset Password</a>
                    </div>
                </label>
                <a href="#" id="logout-link">
                    <i class="fa-solid fa-power-off"></i>
                    <span>Logout</span>
                </a> -->
            </div>
        </div>
    </header>
    <?php
    include_once 'includes/sidebar-admin.php';
    ?>
    <main>

        <!-- <div class="tab-container">
            <div class="tab-links" role="tablist">
                <button class="tab-link active" role="tab" aria-selected="true" data-tab="tab-missed">Missed</button>
                <button class="tab-link" role="tab" aria-selected="false" data-tab="tab-pending">Pending</button>
                <button class="tab-link" role="tab" aria-selected="false" data-tab="tab-low-hours">Low Work
                    Hours</button>
                <button class="tab-link" role="tab" aria-selected="false" data-tab="tab-special-case">Special
                    Cases</button>
            </div>
            <div class="tab-content">
                <div class="tab-panel" id="tab-missed" role="tabpanel">Missed</div>
                <div class="tab-panel" id="tab-pending" role="tabpanel">Pending</div>
                <div class="tab-panel" id="tab-low-hours" role="tabpanel">Low Work Hours</div>
                <div class="tab-panel" id="tab-special-case" role="tabpanel">Special Cases</div>
            </div>
        </div> -->

        <div class="top-row">
            <!-- <h3 class="">Home</h3> -->
            <div class="left">
                <!-- Filter Boxes -->
                <!-- <div class="filters"> -->
                <div class="filter-multiselect">
                    <div class="select-box">Department<i class="fa-solid fa-caret-down"></i></div>
                    <div class="options">
                        <label><input type="checkbox" class="select-all" value="">Select All</label>
                        <?php
                        foreach ($departments as $department) {
                            ?>
                            <label><input type="checkbox" class="filter-option department-filter"
                                    value="<?= $department['dept_id'] ?>"><?= $department['dept_name'] ?></label>
                            <?php
                        }
                        ?>
                    </div>
                </div>
                <div class="filter-multiselect">
                    <div class="select-box">Rep. Manager <i class="fa-solid fa-caret-down"></i></div>
                    <div class="options">
                        <label><input type="checkbox" class="select-all" value="">Select All</label>
                        <?php
                        foreach ($repManagers as $repManager) {
                            ?>
                            <label class="rm-option">
                                <input type="checkbox" class="filter-option rm-filter" value="<?= $repManager['emp_id'] ?>"
                                    data-dept-id="<?= $repManager['dept_id'] ?>"><?= $repManager['name'] ?>
                            </label>
                            <?php
                        }
                        ?>
                    </div>
                </div>
                <div class="filter-multiselect">
                    <div class="select-box">Employee <i class="fa-solid fa-caret-down"></i></div>
                    <div class="options">
                        <label><input type="text" class="employee-filter-input" name="emp-name"
                                placeholder="Search employee..."></label>
                        <label><input type="checkbox" class="employee-filter select-all" value=""> Select All</label>

                        <?php foreach ($accountableEmployees as $teamEmployee) { ?>
                            <label class="employee-option">
                                <input type="checkbox" class="filter-option employee-filter"
                                    value="<?= $teamEmployee['emp_id'] ?>" data-dept-id="<?= $teamEmployee['dept_id'] ?>"
                                    data-rm-id="<?= $teamEmployee['rm_id'] ?>">
                                <?= $teamEmployee['name'] ?>
                            </label>
                        <?php } ?>
                    </div>
                </div>
                <div class="filter-multiselect">
                    <div class="select-box">Timeline<i class="fa-solid fa-caret-down"></i></div>
                    <div class="options">
                        <!-- <label><input type="checkbox" class="select-all timeline-filter" value="">Select All</label> -->
                        <!-- <label><input type="checkbox" class="filter-option timeline-filter" value="today"> Today</label> -->
                        <label><input type="checkbox" class="filter-option timeline-filter" value="last7"> Last 7
                            Days</label>
                        <label><input type="checkbox" class="filter-option timeline-filter" value="last30"> Last 30
                            Days</label>
                        <!-- <label><input type="checkbox" class="filter-option timeline-filter" value="lastyear"> Last
                        Year</label> -->
                        <label id="custom-range-label">
                            <input type="checkbox" class="timeline-filter custom-range-checkbox" value="custom"> Custom
                            <div class="custom-date-range" style="display: none;">
                                From -
                                <input type="date" class="custom-from-date" placeholder="From">
                                To -
                                <input type="date" class="custom-to-date" placeholder="To">
                            </div>
                        </label>
                    </div>
                </div>
                <div class="filter-multiselect" id="status-filter">
                    <div class="select-box">Task Status <i class="fa-solid fa-caret-down"></i></div>
                    <div class="options">
                        <label><input type="checkbox" class="status-filter select-all" value=""> Select All</label>
                        <label><input type="checkbox" class="filter-option status-filter" value="0"> Pending
                        </label>
                        <label><input type="checkbox" class="filter-option status-filter" value="1"> Approved
                        </label>
                        <label><input type="checkbox" class="filter-option status-filter" value="-1"> Unapproved
                        </label>
                    </div>
                </div>
                <!-- </div> -->
            </div>
            <div class="right">
                <button class="action-btn" id="download-list-btn"><i class="fa-solid fa-download"></i></button>
                <button class="action-btn" id="bulk-approve-btn">Approve All</button>
                <button class="action-btn" id="clear-filter-btn">Clear Filters</button>
            </div>
        </div>
        <div class="content-area">
            <div class="tab-container">
                <div class="tab-links" role="tablist">
                    <button class="tab-link active" role="tab" aria-selected="true" data-tab="all">All</button>
                    <button class="tab-link" role="tab" aria-selected="false" data-tab="missed">Not Filled</button>
                    <button class="tab-link" role="tab" aria-selected="false" data-tab="pending">Pending</button>
                    <button class="tab-link" role="tab" aria-selected="false" data-tab="lowhours">Low Work
                        Hours</button>
                    <button class="tab-link" role="tab" aria-selected="false" data-tab="special">Special
                        Cases</button>
                </div>
                <div class="tab-content">
                    <div class="tab-panel active" id="tab-all" role="tabpanel">
                        <div class="tasklist grid-item">
                            <div class="task-table-wrapper">
                                <table id="tasktable">
                                    <thead id="tasktablehead">
                                        <tr>
                                            <th class="checkbox"><input type="checkbox" id="select-all"></th>
                                            <th>Date</th>
                                            <th>Emp Id</th>
                                            <th>Name</th>
                                            <th>Working/Leave</th>
                                            <th>Nature of Task</th>
                                            <th>Task Brief</th>
                                            <th>Description</th>
                                            <th>Duration</th>
                                            <th>Status</th>
                                            <th>Comments</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tasktablebody">
                                        <!-- Employees Tasks to be fetched via Ajax -->
                                    </tbody>
                                </table>
                            </div>
                            <div class="pagination" id="taskPagination">
                                <button class="first">First</button>
                                <button class="prev">Prev</button>
                                <span class="pages"><button class="page-btn active">1</button></span>
                                <button class="next">Next</button>
                                <button class="last">Last</button>
                            </div>
                        </div>
                        <div class="graph graph1 grid-item">
                            <h5>Weekly Work Hours</h5>
                            <!-- Area Chart -->
                            <canvas id="hoursChart"></canvas>
                        </div>
                        <div class="graph graph2 grid-item">
                            <h5>Leaves</h5>
                            <!-- Line Chart -->
                            <canvas id="leavesChart"></canvas>
                        </div>
                        <div class="graph graph3 grid-item">
                            <h5>Working Days</h5>
                            <!-- Pie Chart -->
                            <canvas id="workdaysChart"></canvas>
                        </div>
                    </div>
                    <!-- <div class="tab-panel active" id="tab-all" role="tabpanel">
                        <div class="tasklist grid-item">
                            <div class="task-table-wrapper">
                                <table id="tasktable-all">
                                    <thead>
                                        <tr>
                                            <th class="checkbox"><input type="checkbox" id="select-all"></th>
                                            <th>Date</th>
                                            <th>Emp Id</th>
                                            <th>Name</th>
                                            <th>Working/Leave</th>
                                            <th>Nature of Task</th>
                                            <th>Task Brief</th>
                                            <th>Description</th>
                                            <th>Duration</th>
                                            <th>Status</th>
                                            <th>Comments</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tasktablebody-all">
                                        Employees Tasks to be fetched via Ajax
                                    </tbody>
                                </table>
                            </div>
                            <div class="pagination" id="taskPagination">
                                <button class="first">First</button>
                                <button class="prev">Prev</button>
                                <span class="pages"><button class="page-btn active">1</button></span>
                                <button class="next">Next</button>
                                <button class="last">Last</button>
                            </div>
                        </div>
                        <div class="graph graph1 grid-item">
                            <h5>Weekly Work Hours</h5>
                            Area Chart
                            <canvas id="hoursChart"></canvas>
                        </div>
                        <div class="graph graph2 grid-item">
                            <h5>Leaves</h5>
                            Line Chart
                            <canvas id="leavesChart"></canvas>
                        </div>
                        <div class="graph graph3 grid-item">
                            <h5>Working Days</h5>
                            Pie Chart
                            <canvas id="workdaysChart"></canvas>
                        </div>
                    </div>

                    <div class="tab-panel" id="tab-missed" role="tabpanel">
                        <div class="tasklist grid-item">
                            <div class="task-table-wrapper">
                                <table id="tasktable-missed">
                                    <thead>
                                        <tr>
                                            <th class="checkbox"><input type="checkbox" id="select-all"></th>
                                            <th>Date</th>
                                            <th>Emp Id</th>
                                            <th>Name</th>
                                            <th>Dept.</th>
                                            <th>Sub Dept.</th>
                                            <th>Status</th>
                                            <th>Comments</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tasktablebody-missed">
                                        Employees Tasks to be fetched via Ajax
                                    </tbody>
                                </table>
                            </div>
                            <div class="pagination" id="taskPagination">
                                <button class="first">First</button>
                                <button class="prev">Prev</button>
                                <span class="pages"><button class="page-btn active">1</button></span>
                                <button class="next">Next</button>
                                <button class="last">Last</button>
                            </div>
                        </div>
                        <div class="graph graph1 grid-item">
                            <h5>Weekly Work Hours</h5>
                            Area Chart
                            <canvas id="hoursChart"></canvas>
                        </div>
                        <div class="graph graph2 grid-item">
                            <h5>Leaves</h5>
                            Line Chart
                            <canvas id="leavesChart"></canvas>
                        </div>
                        <div class="graph graph3 grid-item">
                            <h5>Working Days</h5>
                            Pie Chart
                            <canvas id="workdaysChart"></canvas>
                        </div>
                    </div>

                    <div class="tab-panel" id="tab-pending" role="tabpanel">
                        <div class="tasklist grid-item">
                            <div class="task-table-wrapper">
                                <table id="tasktable-pending">
                                    <thead>
                                        <tr>
                                            <th class="checkbox"><input type="checkbox" id="select-all"></th>
                                            <th>Date</th>
                                            <th>Emp Id</th>
                                            <th>Name</th>
                                            <th>Working/Leave</th>
                                            <th>Nature of Task</th>
                                            <th>Task Brief</th>
                                            <th>Description</th>
                                            <th>Duration</th>
                                            <th>Status</th>
                                            <th>Comments</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tasktablebody-pending">
                                        Employees Tasks to be fetched via Ajax
                                    </tbody>
                                </table>
                            </div>
                            <div class="pagination" id="taskPagination">
                                <button class="first">First</button>
                                <button class="prev">Prev</button>
                                <span class="pages"><button class="page-btn active">1</button></span>
                                <button class="next">Next</button>
                                <button class="last">Last</button>
                            </div>
                        </div>
                    </div>

                    <div class="tab-panel" id="tab-low-hours" role="tabpanel">
                        <div class="tasklist grid-item">
                            <div class="task-table-wrapper">
                                <table id="tasktable-low-hours">
                                    <thead>
                                        <tr>
                                            <th class="checkbox"><input type="checkbox" id="select-all"></th>
                                            <th>Date</th>
                                            <th>Emp Id</th>
                                            <th>Name</th>
                                            <th>Working/Leave</th>
                                            <th>Nature of Task</th>
                                            <th>Task Brief</th>
                                            <th>Description</th>
                                            <th>Duration</th>
                                            <th>Status</th>
                                            <th>Comments</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tasktablebody-low-hours">
                                        Employees Tasks to be fetched via Ajax
                                    </tbody>
                                </table>
                            </div>
                            <div class="pagination" id="taskPagination">
                                <button class="first">First</button>
                                <button class="prev">Prev</button>
                                <span class="pages"><button class="page-btn active">1</button></span>
                                <button class="next">Next</button>
                                <button class="last">Last</button>
                            </div>
                        </div>
                    </div>

                    <div class="tab-panel" id="tab-special-case" role="tabpanel">
                        <div class="tasklist grid-item">
                            <div class="task-table-wrapper">
                                <table id="tasktable-special-case">
                                    <thead>
                                        <tr>
                                            <th class="checkbox"><input type="checkbox" id="select-all"></th>
                                            <th>Date</th>
                                            <th>Emp Id</th>
                                            <th>Name</th>
                                            <th>Working/Leave</th>
                                            <th>Nature of Task</th>
                                            <th>Task Brief</th>
                                            <th>Description</th>
                                            <th>Duration</th>
                                            <th>Status</th>
                                            <th>Comments</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tasktablebody-special-case">
                                        Employees Tasks to be fetched via Ajax
                                    </tbody>
                                </table>
                            </div>
                            <div class="pagination" id="taskPagination">
                                <button class="first">First</button>
                                <button class="prev">Prev</button>
                                <span class="pages"><button class="page-btn active">1</button></span>
                                <button class="next">Next</button>
                                <button class="last">Last</button>
                            </div>
                        </div>
                    </div> -->
                </div>
            </div>


            <!-- 
            <div class="tasklist grid-item">
                <div class="task-table-wrapper">
                    <table id="tasktable">
                        <thead>
                            <tr>
                                <th class="checkbox"><input type="checkbox" id="select-all"></th>
                                <th>Date</th>
                                <th>Emp Id</th>
                                <th>Name</th>
                                <th>Working/Leave</th>
                                <th>Nature of Task</th>
                                <th>Task Brief</th>
                                <th>Description</th>
                                <th>Duration</th>
                                <th>Status</th>
                                <th>Comments</th>
                            </tr>
                        </thead>
                        <tbody id="tasktablebody">
                            Employees Tasks to be fetched via Ajax
                        </tbody>
                    </table>
                </div>
                <div class="pagination" id="taskPagination">
                    <button class="first">First</button>
                    <button class="prev">Prev</button>
                    <span class="pages"><button class="page-btn active">1</button></span>
                    <button class="next">Next</button>
                    <button class="last">Last</button>
                </div>
            </div> -->
            <!-- <div class="graph graph1 grid-item">
                <h5>Weekly Work Hours</h5>
                Area Chart
                <canvas id="hoursChart"></canvas>
            </div>
            <div class="graph graph2 grid-item">
                <h5>Leaves</h5>
                Line Chart
                <canvas id="leavesChart"></canvas>
            </div>
            <div class="graph graph3 grid-item">
                <h5>Working Days</h5>
                Pie Chart
                <canvas id="workdaysChart"></canvas>
            </div> -->
        </div>
    </main>
    <!-- <footer></footer> -->

    <!-- Message Toast -->
    <div id="toast">Saved Successfully!</div>

    <!-- Loading Spinner -->
    <div id="spinner-overlay">
        <div class="spinner"></div>
    </div>

    <!-- Custom Alert -->
    <div id="custom-alert" class="alert-overlay">
        <div class="alert-box" id="alert-box">
            <p id="alert-message">Alert Message</p>
            <div class="alert-actions">
                <button id="alert-confirm-btn">Yes</button>
                <button id="alert-cancel-btn">No</button>
            </div>
        </div>
    </div>

    <!-- Task Description Modal -->
    <div id="desc-modal" style="display: none;">
        <div id="desc-modal-content">
            <div id="desc-modal-header">
                <h4 style="font-weight: 500">Task Description</h4>
                <span id="desc-modal-close">&times;</span>
            </div>
            <hr>
            <div id="desc-modal-body"></div>
        </div>
    </div>

    <script>
        // Show modal with full description
        document.addEventListener('click', function (e) {
            const target = e.target;
            if (target.classList.contains('description-cell')) {
                const fullText = target.dataset.full;
                if (fullText && fullText !== '-') {
                    document.getElementById('desc-modal-body').textContent = fullText;
                    document.getElementById('desc-modal').style.display = 'flex';
                }
            }
        });

        // Close modal
        document.getElementById('desc-modal-close').addEventListener('click', function () {
            document.getElementById('desc-modal').style.display = 'none';
        });

        // Optional: Close on overlay click
        document.getElementById('desc-modal').addEventListener('click', function (e) {
            if (e.target.id === 'desc-modal') {
                e.currentTarget.style.display = 'none';
            }
        });

    </script>

    <?php
    // Add task entry modal
    // include_once 'task-modal.php';
    // Edit Profile Photo Modal 
    include_once 'photo-modal.php';
    ?>

    <script>
        function showToast(message, isError = false) {
            const toast = document.getElementById('toast');
            toast.textContent = message;

            if (isError) {
                toast.style.backgroundColor = '#ef828c';
            } else {
                toast.style.backgroundColor = '#5eda7b';
            }

            toast.className = 'show';

            setTimeout(() => { toast.classList.remove('show') }, 3000);
        }

    </script>

    <!-- Task Modal Script -->
    <!-- <script>
        const addModal = document.getElementById('modal-dialog-common');
        // const addButton = document.getElementById('add-btn');
        const openButton = document.getElementById('open-modal-btn');
        const closeButton = document.getElementById('close-btn');

        openButton.addEventListener('click', function (e) {
            addModal.classList.add('show');
        });

        // Close modal
        closeButton.addEventListener('click', () => {
            addModal.classList.remove('show');
        });

        window.addEventListener('click', (e) => {
            if (addModal === e.target) addModal.classList.remove('show');
        })
    </script> -->

    <!-- Graphs Script -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <script src="assets/js/graph.js"></script>

    <!-- globally declare currentTab -->
    <script>
        let currentTab = "all"; // default active tab
        const statusFilter = document.getElementById('status-filter');
    </script>

    <!-- Filters handling script -->
    <!-- <script src="assets/js/filters.js"></script> -->
    <script>

        // Filter Script
        const filters = document.querySelectorAll('.filter-multiselect');

        filters.forEach(filter => {
            const selectBox = filter.querySelector('.select-box');
            const options = filter.querySelector('.options');

            // Toggle dropdown
            selectBox.addEventListener('click', (e) => {
                e.stopPropagation();

                if (filter.classList.contains('active')) {
                    filter.classList.remove('active');
                    return;
                }

                filters.forEach(f => {
                    if (f !== filter) f.classList.remove('active');
                });

                filter.classList.add('active');
            });

            if (options) {
                options.addEventListener('click', e => e.stopPropagation());
            }
        });

        // Close all on outside click
        window.addEventListener('click', () => {
            filters.forEach(filter => {
                filter.classList.remove('active');
            });
        });


        // Select All Checkbox Script
        document.querySelectorAll('.select-all').forEach(selectAllCheckbox => {
            selectAllCheckbox.addEventListener('change', function () {
                const container = this.closest('.filter-multiselect');
                const checkboxes = container.querySelectorAll('input[type="checkbox"]:not(.select-all)');
                checkboxes.forEach(cb => cb.checked = this.checked);
            });
        });

        // Sync "Select All" when individual checkboxes are changed
        document.querySelectorAll('.filter-option').forEach(option => {
            option.addEventListener('change', function () {
                const container = this.closest('.filter-multiselect');
                const allCheckboxes = container.querySelectorAll('.filter-option');
                const allChecked = Array.from(allCheckboxes).every(cb => cb.checked);
                container.querySelector('.select-all').checked = allChecked;
            });
        });


        document.addEventListener("DOMContentLoaded", function () {
            const customCheckbox = document.querySelector('.custom-range-checkbox');
            const dateRange = document.querySelector('.custom-date-range');
            const allCheckboxes = document.querySelectorAll('.timeline-filter:not(.custom-range-checkbox)');
            const fromDate = document.querySelector('.custom-from-date');
            const toDate = document.querySelector('.custom-to-date');

            // Set max attributes to today
            const today = new Date().toISOString().split('T')[0];
            fromDate.setAttribute('max', today);
            toDate.setAttribute('max', today);

            function validateDateRange() {
                if (fromDate.value && toDate.value && fromDate.value > toDate.value) {
                    // alert("From date cannot be after To date.");
                    toDate.value = '';
                    fromDate.setAttribute('max', today); // Reset max to today
                }
            }

            fromDate.addEventListener('change', () => {
                if (fromDate.value) {
                    toDate.min = fromDate.value;
                } else {
                    toDate.min = "";
                }
                validateDateRange();
            });

            toDate.addEventListener('change', function () {
                validateDateRange();

                if (toDate.value) {
                    fromDate.setAttribute('max', toDate.value);
                } else {
                    // Reset to max = today if toDate is cleared
                    fromDate.setAttribute('max', today);
                }
            });

            // Handle custom checkbox toggle
            customCheckbox.addEventListener('change', function () {
                if (this.checked) {
                    dateRange.style.display = 'flex';

                    // Uncheck all other timeline checkboxes
                    allCheckboxes.forEach(cb => {
                        cb.checked = false;
                    });
                } else {
                    dateRange.style.display = 'none';
                }
            });

            // Handle other timeline checkboxes
            allCheckboxes.forEach(cb => {
                cb.addEventListener('change', function () {
                    if (this.checked) {
                        // Uncheck all other timeline checkboxes
                        allCheckboxes.forEach(otherCb => {
                            if (otherCb !== this) {
                                otherCb.checked = false;
                            }
                        });

                        // Uncheck custom and hide date range
                        customCheckbox.checked = false;
                        dateRange.style.display = 'none';
                    }
                });
            });

            // Set initial visibility based on custom checkbox state
            dateRange.style.display = customCheckbox.checked ? 'block' : 'none';
        });


        // Filter Employee names on Input
        document.addEventListener('DOMContentLoaded', function () {
            const searchInput = document.querySelector('.employee-filter-input');
            const employeeOptions = document.querySelectorAll('.employee-option');

            if (searchInput) {
                searchInput.addEventListener('keyup', function () {
                    const filterValue = searchInput.value.toLowerCase();

                    employeeOptions.forEach(option => {
                        const labelText = option.textContent.toLowerCase();
                        if (labelText.includes(filterValue)) {
                            option.style.display = 'flex';
                        } else {
                            option.style.display = 'none';
                        }
                    });
                });
            }
        });



        document.getElementById('clear-filter-btn').addEventListener('click', function () {
            // Uncheck all checkboxes
            document.querySelectorAll('.filter-option, .select-all, .timeline-filter, .employee-filter').forEach(checkbox => {
                checkbox.checked = false;
            });

            // Clear the employee search input
            if (document.querySelector('.employee-filter-input')) document.querySelector('.employee-filter-input').value = '';
            console.log('Filters cleared.');

            loadTasks(currentTab, getFilterValues());
            // applyFilters();
        });

    </script>

    <script>
        document.addEventListener("DOMContentLoaded", () => {
            const deptCheckboxes = document.querySelectorAll(".department-filter");
            const rmOptions = document.querySelectorAll(".rm-option");
            const rmCheckboxes = document.querySelectorAll(".rm-filter");
            const employeeOptions = document.querySelectorAll(".employee-option");

            function getSelectedValues(checkboxes) {
                return Array.from(checkboxes)
                    .filter(cb => cb.checked)
                    .map(cb => cb.value);
            }

            function updateRMFilter(selectedDepts) {
                rmOptions.forEach(option => {
                    const checkbox = option.querySelector("input.rm-filter");
                    const deptId = checkbox.dataset.deptId;

                    if (selectedDepts.length === 0 || selectedDepts.includes(deptId)) {
                        option.style.display = "flex";
                    } else {
                        option.style.display = "none";
                        checkbox.checked = false; // Uncheck if hidden
                    }
                });
            }

            function updateEmployeeFilter(selectedDepts, selectedRMs) {
                employeeOptions.forEach(option => {
                    const checkbox = option.querySelector("input.employee-filter");
                    const empDeptId = checkbox.dataset.deptId;
                    const empRmId = checkbox.dataset.rmId;

                    const showByDept = selectedDepts.length === 0 || selectedDepts.includes(empDeptId);
                    const showByRM = selectedRMs.length === 0 || selectedRMs.includes(empRmId);

                    if (showByDept && showByRM) {
                        option.style.display = "flex";
                    } else {
                        option.style.display = "none";
                        checkbox.checked = false; // Uncheck if hidden
                    }
                });
            }

            function updateAllFilters() {
                const selectedDepts = getSelectedValues(deptCheckboxes);
                const selectedRMs = getSelectedValues(rmCheckboxes);

                updateRMFilter(selectedDepts);
                updateEmployeeFilter(selectedDepts, selectedRMs);
            }

            deptCheckboxes.forEach(cb => cb.addEventListener("change", updateAllFilters));
            rmCheckboxes.forEach(cb => cb.addEventListener("change", updateAllFilters));

            updateAllFilters(); // Initial run
        });
    </script>


    <script>
        const loggedUserId = <?= $emp_id ?>;
    </script>

    <script>

        let currentPage = 1;
        let limit = 25; // default rows per page


        // document.addEventListener('DOMContentLoaded', function () {
        //     const filterInputs = document.querySelectorAll('.filter-option, .timeline-filter, .rm-filter, .employee-filter, .status-filter, .custom-from-date, .custom-to-date');
        //     const taskTableContainer = document.querySelector('.task-table-wrapper');

        //     filterInputs.forEach(input => {
        //         input.addEventListener('change', applyFilters);
        //     });

        //     // Exposing applyFilters() to window scope to call globally
        //     window.applyFilters = applyFilters;

        //     function applyFilters() {
        //         const selectedDepartments = Array.from(document.querySelectorAll('.department-filter:checked')).map(el => el.value);
        //         const selectedManagers = Array.from(document.querySelectorAll('.rm-filter:checked')).map(el => el.value);
        //         const selectedEmployees = Array.from(document.querySelectorAll('.employee-filter:checked')).map(el => el.value);
        //         const selectedStatus = Array.from(document.querySelectorAll('.status-filter:checked')).map(el => el.value);

        //         const customCheckbox = document.querySelector('.custom-range-checkbox');
        //         let timeline = '';
        //         let customFrom = '';
        //         let customTo = '';

        //         if (customCheckbox.checked) {
        //             customFrom = document.querySelector('.custom-from-date').value;
        //             customTo = document.querySelector('.custom-to-date').value;
        //             timeline = 'custom';
        //         } else {
        //             const selectedTimelines = Array.from(document.querySelectorAll('.timeline-filter:checked')).map(el => el.value);
        //             if (selectedTimelines.length > 0) {
        //                 timeline = selectedTimelines[0];
        //             }
        //         }

        //         showSpinner();

        //         fetch('api/filter-tasks.php', {
        //             method: 'POST',
        //             headers: { 'Content-Type': 'application/json' },
        //             body: JSON.stringify({
        //                 loggedUserId: loggedUserId,
        //                 employees: selectedEmployees,
        //                 departments: selectedDepartments,
        //                 managers: selectedManagers,
        //                 status: selectedStatus,
        //                 timeline: timeline,
        //                 customFrom: customFrom,
        //                 customTo: customTo,
        //                 page: currentPage,
        //                 limit: limit
        //             })

        //         })
        //             .then(response => response.json())
        //             .then(data => {
        //                 updateTaskTable(data.tasks);
        //                 renderPagination(data.total, data.page, data.limit);
        //                 taskTableContainer.scrollTo({ top: 0 });

        //                 const graphContainers = document.querySelectorAll('.graph');

        //                 if (selectedEmployees.length === 1) {
        //                     // Case 1: Single employee selected
        //                     loadGraphs([selectedEmployees[0]]);
        //                     graphContainers.forEach(graph => graph.style.display = 'flex');
        //                     document.querySelector('.content-area').style.display = 'grid';

        //                 } else if (selectedEmployees.length === 0 && selectedManagers.length > 0) {
        //                     // Case 2: RM(s) selected, no specific employee selected — show only visible filtered employees
        //                     const allEmployeeInputs = document.querySelectorAll('.filter-option.employee-filter');
        //                     const filteredVisibleEmpIds = Array.from(allEmployeeInputs)
        //                         .filter(el => el.closest('.employee-option')?.style.display !== 'none')
        //                         .map(el => el.value);
        //                     ////////console.log(filteredVisibleEmpIds);

        //                     if (filteredVisibleEmpIds.length > 0) {
        //                         loadGraphs(filteredVisibleEmpIds);
        //                         graphContainers.forEach(graph => graph.style.display = 'flex');
        //                         document.querySelector('.content-area').style.display = 'grid';
        //                     } else {
        //                         hideGraphs();
        //                     }

        //                 } else {
        //                     // Case 3: Don't show graphs
        //                     hideGraphs();
        //                 }
        //             })
        //             .catch(error => console.error('Error:', error))
        //             .finally(() => {
        //                 hideSpinner();
        //             });
        //     }



        document.addEventListener("DOMContentLoaded", function () {
            const taskTable = document.getElementById("tasktable");

            console.log(taskTable);
            const tbody = taskTable.querySelector("#tasktablebody");

            const tabs = document.querySelectorAll(".tab-links .tab-link");
            // let currentTab = "all"; // default active tab

            // --- Load default tab on page load ---
            loadTasks(currentTab, getFilterValues());


            const filterInputs = document.querySelectorAll('.filter-option, .timeline-filter, .rm-filter, .employee-filter, .status-filter, .custom-from-date, .custom-to-date');

            filterInputs.forEach(input => {
                input.addEventListener('change', () => {
                    loadTasks(currentTab, getFilterValues())
                });
            });

            // --- Tab click event ---
            tabs.forEach(tab => {
                tab.addEventListener("click", function (e) {
                    e.preventDefault();
                    tabs.forEach(t => t.classList.remove("active"));
                    this.classList.add("active");
                    currentTab = this.getAttribute("data-tab");
                    handleFilterVisibility(currentTab);
                    loadTasks(currentTab, getFilterValues());
                });
            });

            function handleFilterVisibility(tab) {
                // Tabs where status filter should be hidden
                const hideFor = ['pending', 'missed', 'lowhours'];

                if (hideFor.includes(tab)) {
                    statusFilter.style.display = 'none';
                    clearStatusSelection(); // clear checkboxes so no status filter is applied
                } else {
                    statusFilter.style.display = 'block';
                }
            }

            function clearStatusSelection() {
                document.querySelectorAll('#status-filter input[type="checkbox"]').forEach(cb => {
                    cb.checked = false;
                });
            }

            // --- Filter application ---
            // document.querySelector("#applyFiltersBtn").addEventListener("click", function () {
            //     loadTasks(currentTab, getFilterValues());
            // });

            // Make getFilterValues globally accessible
            // window.getFilterValues = getFilterValues;

            // --- Get filter values from panel ---
            // function getFilterValues() {
            //     // Adjust these selectors to match your filter inputs
            //     // const employee = document.querySelector("#filterEmployee")?.value || "";
            //     // const client = document.querySelector("#filterClient")?.value || "";
            //     // const startDate = document.querySelector("#filterStartDate")?.value || "";
            //     // const endDate = document.querySelector("#filterEndDate")?.value || "";

            //     const selectedDepartments = Array.from(document.querySelectorAll('.department-filter:checked')).map(el => el.value);
            //     const selectedManagers = Array.from(document.querySelectorAll('.rm-filter:checked')).map(el => el.value);
            //     const selectedEmployees = Array.from(document.querySelectorAll('.employee-filter:checked')).map(el => el.value);
            //     const selectedStatus = Array.from(document.querySelectorAll('.status-filter:checked')).map(el => el.value);

            //     const customCheckbox = document.querySelector('.custom-range-checkbox');
            //     let timeline = '';
            //     let customFrom = '';
            //     let customTo = '';

            //     if (customCheckbox.checked) {
            //         customFrom = document.querySelector('.custom-from-date').value;
            //         customTo = document.querySelector('.custom-to-date').value;
            //         timeline = 'custom';
            //     } else {
            //         const selectedTimelines = Array.from(document.querySelectorAll('.timeline-filter:checked')).map(el => el.value);
            //         if (selectedTimelines.length > 0) {
            //             timeline = selectedTimelines[0];
            //         }
            //     }

            //     return { selectedEmployees, selectedDepartments, selectedManagers, selectedStatus, timeline, customFrom, customTo };
            // }

            // Exposing loadTasks() to window scope to call globally
            window.loadTasks = loadTasks;

            // --- Main task loader ---
            function loadTasks(type, filters = {}) {
                // Build the payload body
                const payload = {
                    taskType: type, // e.g. 'all', 'missed', 'pending', 'lowwork', 'special'
                    employees: filters.selectedEmployees,
                    departments: filters.selectedDepartments,
                    managers: filters.selectedManagers,
                    status: filters.selectedStatus,
                    timeline: filters.timeline,
                    customFrom: filters.customFrom,
                    customTo: filters.customTo      // spread all filter parameters (employees, departments, etc.)
                };

                fetch('api/filter-tasks.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(payload)
                })
                    .then(res => res.json())
                    .then(data => {
                        // Define columns based on tab type
                        let columns = [];
                        switch (type) {
                            case "missed": columns = ["Date", "Emp Id", "Name", "Email", "Rep. Manager"]; break;
                            case "lowhours": columns = ["Date", "Emp Id", "Name", "Email", "Rep. Manager", "Total Time"]; break;
                            case "special": columns = ["Date", "Occasion", "Emp Id", "Name", "Work Type", "Duration", "Nature of Task", "Task Brief", "Description", "Status", "Comments"]; break;
                            default: columns = ["Date", "Emp Id", "Name", "Work Type", "Duration", "Nature of Task", "Task Brief", "Description", "Status", "Comments"];
                        }

                        // Update table header
                        const thead = taskTable.querySelector("#tasktablehead");
                        thead.innerHTML = '<tr><th class="checkbox"><input type="checkbox" id="select-all"></th>' + columns.map(c => `<th>${c}</th>`).join("") + '</tr>';

                        // Update table body
                        tbody.innerHTML = "";
                        if (data.length === 0) {
                            tbody.innerHTML = `<tr><td colspan="${columns.length}">No tasks found</td></tr>`;
                            return;
                        }

                        // Render each row
                        data.tasks.forEach(task => {
                            let row = `<tr data-task-id="${task.task_id}">`;
                            row += `<td class="checkbox"><input type="checkbox" class="select-task"></td>`;
                            columns.forEach(col => {
                                switch (col) {
                                    case "Date": row += `<td>${formatDate(task.date)}</td>`; break;
                                    case "Occasion": row += `<td>${(task.occasion)}</td>`; break;
                                    case "Emp Id": row += `<td>${task.emp_id}</td>`; break;
                                    case "Name": row += `<td>${task.name}</td>`; break;
                                    case "Email": row += `<td>${task.email}</td>`; break;
                                    case "Rep. Manager": row += `<td>${task.rm_name}</td>`; break;
                                    case "Work Type": row += `<td>${task.worktype || "-"}</td>`; break;
                                    case "Duration": row += `<td>${formatTime(task.duration) || "-"}</td>`; break;
                                    case "Total Time": row += `<td>${formatTime(task.total_duration) || "-"}</td>`; break;
                                    case "Nature of Task": row += `<td>${task.cat_name}</td>`; break;
                                    case "Task Brief": row += `<td>${task.brief || '-'}</td>`; break;
                                    case "Description": row += `<td class="description-cell" data-full="${task.description || '-'}">${task.description?.substring(0, 50) || ''}${task.description?.length > 50 ? '...' : ''}</td>`; break;
                                    // case "Status": row += `<td>${task.status}</td>`; break;
                                    case "Status": row += `<td>
                                      <select name="status-dropdown" class="status-dropdown ${task.status == '0' ? 'pending' : task.status == 1 ? 'approved' : 'unapproved'}">
                                            <option value="0" ${task.status == 0 ? 'selected' : ''} disabled hidden>Pending</option>
                                            <option value="1" ${task.status == 1 ? 'selected' : ''}>Approved</option>
                                            <option value="-1" ${task.status == -1 ? 'selected' : ''}>Unapproved</option>
                                        </select>`;
                                        break;
                                    case "Comments": row += `<td><input type="text" name="comment" value="${task.comment ?? ''}" placeholder="Add Comment" readonly></td>`; break;
                                    case "Actions": row += `<td>Actions</td>`; break;
                                }
                            });
                            row += "</tr>";
                            tbody.insertAdjacentHTML("beforeend", row);
                        });

                        const graphContainers = document.querySelectorAll('.graph');

                        if (filters.selectedEmployees.length === 1) {
                            // Case 1: Single employee selected
                            loadGraphs([filters.selectedEmployees[0]]);
                            graphContainers.forEach(graph => graph.style.display = 'flex');
                            document.querySelector('.tab-panel.active').style.display = 'grid';

                        } else if (filters.selectedEmployees.length === 0 && filters.selectedManagers.length > 0) {
                            // Case 2: RM(s) selected, no specific employee selected — show only visible filtered employees
                            const allEmployeeInputs = document.querySelectorAll('.filter-option.employee-filter');
                            const filteredVisibleEmpIds = Array.from(allEmployeeInputs)
                                .filter(el => el.closest('.employee-option')?.style.display !== 'none')
                                .map(el => el.value);
                            ////////console.log(filteredVisibleEmpIds);

                            if (filteredVisibleEmpIds.length > 0) {
                                loadGraphs(filteredVisibleEmpIds);
                                graphContainers.forEach(graph => graph.style.display = 'flex');
                                document.querySelector('.tab-panel.active').style.display = 'grid';
                            } else {
                                hideGraphs();
                            }

                        } else {
                            // Case 3: Don't show graphs
                            hideGraphs();
                        }
                        // console.log(payload);



                    })
                    .catch(err => {
                        console.error("Error loading tasks:", err);
                        tbody.innerHTML = `<tr><td colspan="6">Error loading tasks</td></tr>`;
                    });
            }
        });

        function getFilterValues() {
            // Adjust these selectors to match your filter inputs
            // const employee = document.querySelector("#filterEmployee")?.value || "";
            // const client = document.querySelector("#filterClient")?.value || "";
            // const startDate = document.querySelector("#filterStartDate")?.value || "";
            // const endDate = document.querySelector("#filterEndDate")?.value || "";

            const selectedDepartments = Array.from(document.querySelectorAll('.department-filter:checked')).map(el => el.value);
            const selectedManagers = Array.from(document.querySelectorAll('.rm-filter:checked')).map(el => el.value);
            const selectedEmployees = Array.from(document.querySelectorAll('.employee-filter:checked')).map(el => el.value);
            const selectedStatus = Array.from(document.querySelectorAll('.status-filter:checked')).map(el => el.value);

            const customCheckbox = document.querySelector('.custom-range-checkbox');
            let timeline = '';
            let customFrom = '';
            let customTo = '';

            if (customCheckbox.checked) {
                customFrom = document.querySelector('.custom-from-date').value;
                customTo = document.querySelector('.custom-to-date').value;
                timeline = 'custom';
            } else {
                const selectedTimelines = Array.from(document.querySelectorAll('.timeline-filter:checked')).map(el => el.value);
                if (selectedTimelines.length > 0) {
                    timeline = selectedTimelines[0];
                }
            }


            return { selectedEmployees, selectedDepartments, selectedManagers, selectedStatus, timeline, customFrom, customTo };
        }

        function updateTaskTable(tasks) {
            const tableBody = document.querySelector('#tasktablebody');
            tableBody.innerHTML = '';

            if (tasks.length !== 0) {
                tasks.forEach(task => {
                    let row = `
                        <tr data-task-id="${task.task_id}">
                            <td class="checkbox"><input type="checkbox" class="select-task"></td>
                            <td>${formatDate(task.date)}</td>
                            <td>${task.emp_id}</td>
                            <td>${task.emp_name}</td>
                            <td>${task.worktype}</td>
                            <td>${task.cat_name}</td>
                            <td>${task.brief || '-'}</td>
                            <td class="description-cell" data-full="${task.description || '-'}">
                                ${task.description?.substring(0, 50) || ''}${task.description?.length > 50 ? '...' : ''}
                            </td>
                            <td>${formatTime(task.duration)}</td>
                            <td>
                                <select name="status-dropdown" class="status-dropdown ${task.status == '0' ? 'pending' : task.status == 1 ? 'approved' : 'unapproved'}">
                                    <option value="0" ${task.status == 0 ? 'selected' : ''} disabled hidden>Pending</option>
                                    <option value="1" ${task.status == 1 ? 'selected' : ''}>Approved</option>
                                    <option value="-1" ${task.status == -1 ? 'selected' : ''}>Unapproved</option>
                                </select>
                            </td>
                            <td><input type="text" name="comment" value="${task.comment ?? ''}" placeholder="Add Comment" readonly></td>
                        </tr>
                    `;
                    tableBody.innerHTML += row;
                });

            } else {
                tableBody.innerHTML = `
                    <tr style="background-color: #e0f5ff;">
                        <td colspan="5" style="text-align: center;">
                            <h3>No Entries</h3>
                        </td>
                    </tr>
                `;
            }
        }

        function hideGraphs() {
            const graphContainers = document.querySelectorAll('.graph');
            graphContainers.forEach(graph => graph.style.display = 'none');
            document.querySelector('.tab-panel.active').style.display = 'flex';

            if (hoursChart instanceof Chart) {
                hoursChart.destroy();
                hoursChart = null;
            }

            if (typeof leavesChart !== 'undefined' && leavesChart instanceof Chart) {
                leavesChart.destroy();
            }

            if (workdaysChart instanceof Chart) {
                workdaysChart.destroy();
                workdaysChart = null;
            }
        }

        function renderPagination(total, page, limit) {
            const totalPages = Math.ceil(total / limit);
            const container = document.getElementById("taskPagination");

            container.querySelector(".first").onclick = () => { currentPage = 1; applyFilters(); };
            container.querySelector(".prev").onclick = () => { if (currentPage > 1) { currentPage--; applyFilters(); } };
            container.querySelector(".next").onclick = () => { if (currentPage < totalPages) { currentPage++; applyFilters(); } };
            container.querySelector(".last").onclick = () => { currentPage = totalPages; applyFilters(); };

            const pagesContainer = container.querySelector(".pages");
            pagesContainer.innerHTML = ""; // clear old

            const windowSize = 2;
            let start = Math.max(1, page - windowSize);
            let end = Math.min(totalPages, page + windowSize);

            if (start > 1) {
                addPageButton(pagesContainer, 1, page);
                if (start > 2) addEllipsis(pagesContainer);
            }

            for (let i = start; i <= end; i++) {
                addPageButton(pagesContainer, i, page);
            }

            if (end < totalPages) {
                if (end < totalPages - 1) addEllipsis(pagesContainer);
                addPageButton(pagesContainer, totalPages, page);
            }

            function addPageButton(container, i, current) {
                const btn = document.createElement("button");
                btn.textContent = i;
                btn.className = "page-btn";
                if (i === current) btn.classList.add("active"); // highlight instead of disable
                btn.onclick = () => { currentPage = i; applyFilters(); };
                container.appendChild(btn);
            }

            function addEllipsis(container) {
                const span = document.createElement("span");
                span.textContent = "...";
                container.appendChild(span);
            }
        }


        // applyFilters();
        // });
    </script>

    <!-- <script>
        // Logic to switch tabs
        document.addEventListener('DOMContentLoaded', function () {
            const tabs = document.querySelectorAll('.tab-link');
            const panels = document.querySelectorAll('.tab-panel');

            // Restore last active tab from localStorage (if any)
            const lastTabId = localStorage.getItem('activeTabId');
            if (lastTabId) {
                const activeTab = document.querySelector(`.tab-link[data-tab="${lastTabId}"]`);
                const activePanel = document.getElementById(lastTabId);
                if (activeTab && activePanel) {
                    // Remove existing active states
                    tabs.forEach(t => {
                        t.classList.remove('active');
                        t.setAttribute('aria-selected', 'false');
                    });
                    panels.forEach(panel => panel.classList.remove('active'));

                    // Set saved tab as active
                    activeTab.classList.add('active');
                    activeTab.setAttribute('aria-selected', 'true');
                    activePanel.classList.add('active');
                }
            }

            tabs.forEach(tab => {
                tab.addEventListener('click', () => {
                    const target = tab.getAttribute('data-tab');

                    // Save clicked tab to localStorage
                    localStorage.setItem('activeTabId', target);

                    // Remove active from all tabs/panels
                    tabs.forEach(t => {
                        t.classList.remove('active');
                        t.setAttribute('aria-selected', 'false');
                    });
                    panels.forEach(panel => panel.classList.remove('active'));

                    // Activate clicked tab/panel
                    tab.classList.add('active');
                    tab.setAttribute('aria-selected', 'true');
                    document.getElementById(target).classList.add('active');
                });
            });

            tabs.forEach(tab => {
                tab.addEventListener('click', () => {
                    const target = tab.getAttribute('data-tab');

                    // Save clicked tab to localStorage
                    localStorage.setItem('activeTabId', target);

                    // Remove active from all tabs/panels
                    tabs.forEach(t => {
                        t.classList.remove('active');
                        t.setAttribute('aria-selected', 'false');
                    });
                    panels.forEach(panel => panel.classList.remove('active'));

                    // Activate clicked tab/panel
                    tab.classList.add('active');
                    tab.setAttribute('aria-selected', 'true');
                    const activePanel = document.getElementById(target);
                    activePanel.classList.add('active');

                    // Load tasks for that case
                    const caseType = target.replace("tab-", ""); // e.g. "tab-missed" → "missed"
                    loadTasks(caseType, target);
                });
            });

        });

        // Initial load
        const initialTabId = localStorage.getItem('activeTabId') || "tab-all";
        document.querySelector(`.tab-link[data-tab="${initialTabId}"]`).click();


        function loadTasks(caseType, targetPanelId) {
            const formData = new FormData();
            formData.append("caseType", caseType);

            fetch("api/filter-tasks.php", { method: "POST", body: formData })
                .then(res => res.text())
                .then(html => {
                    document.getElementById(targetPanelId).innerHTML = html;
                });
        }


    </script> -->


    <script src="assets/js/profile.js"></script>
    <script>
        // window.onload = function () {
        //     alert('here');
        //     document.querySelectorAll('td.task-date').forEach(cell => {
        //         cell.textContent = formatDate(cell.textContent);
        //     });
        // }

        window.onload = function () {

            document.querySelectorAll('td.task-date').forEach(cell => {
                cell.textContent = formatDate(cell.textContent);
            });

            document.querySelectorAll('td.task-duration').forEach(cell => {
                cell.textContent = formatTime(cell.textContent);
            });

        }

        // Date formatting function
        function formatDate(dateString) {
            const parts = dateString.split('-'); // ["YYYY", "MM", "DD"]
            return `${parts[2]}-${parts[1]}-${parts[0]}`; // "DD-MM-YYYY"
        }

        // Duration formatting function
        function formatTime(timeString) {
            return timeString.slice(0, 5); // Converts '02:30:00' to '02:30'
        }


    </script>

    <script>
        function showSpinner() {
            document.getElementById('spinner-overlay').style.display = 'block';
        }

        function hideSpinner() {
            document.getElementById('spinner-overlay').style.display = 'none';
        }

    </script>


    <!-- <script src="assets/js/add.js"></script> -->
    <script src="assets/js/alert.js"></script>
    <script src="assets/js/approve.js"></script>
    <script src="assets/js/main.js"></script>
    <!-- <script>
        function showCommentPopup(onConfirm, onCancel) {
            showAlert('Please enter comment for disapproval:', function () {
                const comment = document.getElementById('popup-comment-input').value;
                onConfirm(comment);
            }, function () {
                if (onCancel) onCancel(); // Call onCancel when user clicks Cancel
            }, 'Submit', 'Cancel');

            document.getElementById('alert-message').innerHTML = `
        Please enter comment for disapproval:
        <input type="text" id="popup-comment-input" placeholder="Enter comment" style="margin-top:10px;width:90%;" />
    `;
        }


    </script> -->


    <!-- Multiple Task Script -->
    <script>
        // document.getElementById('select-all').addEventListener('change', function () {
        //     const allCheckboxes = document.querySelectorAll('input.select-task');
        //     allCheckboxes.forEach(cb => cb.checked = this.checked);
        // });

        document.addEventListener('change', function (e) {
            const target = e.target;
            if (target.id == 'select-all') {
                const allCheckboxes = document.querySelectorAll('input.select-task');
                allCheckboxes.forEach(cb => cb.checked = target.checked);
            }
        });
    </script>

    <!-- Excel Download Script CDN -->
    <!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script> -->
    <!-- Excel Download Script -->
    <!-- <script>
        document.getElementById('download-list-btn').addEventListener('click', function () {
            const table = document.getElementById('tasktable');
            const rows = table.querySelectorAll('tbody tr');
            const data = [];

            // Add header row
            const headers = ["Date", "Emp Id", "Name", "Working/Leave", "Nature of Task", "Task Brief", "Task Description", "Duration", "Status", "Comments"];
            data.push(headers);

            // Extract data rows
            rows.forEach(row => {
                const cells = row.querySelectorAll('td');
                const rowData = [];

                rowData.push(cells[1].innerText.trim()); // Date
                rowData.push(cells[2].innerText.trim()); // Emp Id
                rowData.push(cells[3].innerText.trim()); // Name
                rowData.push(cells[4].innerText.trim()); // Working/Leave
                rowData.push(cells[5].innerText.trim()); // Nature of Task
                rowData.push(cells[6].innerText.trim()); // Task Brief
                rowData.push(cells[7].innerText.trim()); // Task Description
                rowData.push(cells[8].innerText.trim()); // Duration

                const select = cells[9].querySelector('select');
                const statusText = select ? select.options[select.selectedIndex].textContent.trim() : '';
                rowData.push(statusText);

                const commentInput = cells[10].querySelector('input[type="text"]');
                rowData.push(commentInput ? commentInput.value.trim() : '');

                data.push(rowData);
            });

            // Create worksheet
            const worksheet = XLSX.utils.aoa_to_sheet(data);

            // Set header bold
            headers.forEach((_, colIdx) => {
                const cellAddress = XLSX.utils.encode_cell({ r: 0, c: colIdx }); // first row = 0
                if (!worksheet[cellAddress]) return;
                worksheet[cellAddress].s = {
                    font: {
                        bold: true
                    }
                };
            });

            // Auto column widths
            const colWidths = headers.map((_, colIdx) => {
                let maxLen = headers[colIdx].length;
                data.slice(1).forEach(row => {
                    const val = row[colIdx];
                    if (val && val.length > maxLen) {
                        maxLen = val.length;
                    }
                });
                return { wch: maxLen + 2 }; // padding for readability
            });
            worksheet['!cols'] = colWidths;

            // Final workbook
            const workbook = XLSX.utils.book_new();
            XLSX.utils.book_append_sheet(workbook, worksheet, "Tasks");

            XLSX.writeFile(workbook, "task-list.xlsx");
        });
    </script> -->

    <!-- Excel Download Script CDN -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

    <script>
        document.getElementById('download-list-btn').addEventListener('click', async function () {
            try {
                // 1. Fetch all task entries from API (adjust URL as needed)
                const response = await fetch('api/filter-tasks.php');
                const result = await response.json();

                if (!result.success || !result.tasks || result.tasks.length === 0) {
                    alert("No task data found!");
                    return;
                }

                const allTasks = result.tasks;

                console.log(allTasks);


                //  2. Define headers (adjust according to backend field names)
                const headers = [
                    "Date", "Emp Id", "Email", "Name", "Working/Leave", "Nature of Task",
                    "Task Brief", "Task Description", "Duration", "Status", "Comments"
                ];
                const data = [headers];

                //  3. Convert API data to Excel rows
                allTasks.forEach(task => {
                    const rowData = [
                        formatDate(task.date) || '',
                        task.emp_id || '',
                        task.name || '',
                        task.email || '',
                        task.worktype || '',
                        task.cat_name || '',
                        task.brief || '-',
                        task.description || '-',
                        formatTime(task.duration) || '',
                        task.status != null
                            ? task.status === 0
                                ? 'Pending'
                                : task.status === 1
                                    ? 'Approved'
                                    : 'Not Approved'
                            : '-', // Returns '' if task.status is null or undefined
                        // task.status || '',
                        task.comment || ''
                    ];
                    data.push(rowData);
                });

                //  4. Create worksheet
                const worksheet = XLSX.utils.aoa_to_sheet(data);

                // Bold headers
                headers.forEach((_, colIdx) => {
                    const cellAddress = XLSX.utils.encode_cell({ r: 0, c: colIdx });
                    if (!worksheet[cellAddress]) return;
                    worksheet[cellAddress].s = { font: { bold: true } };
                });

                // Auto column widths
                worksheet['!cols'] = headers.map((header, i) => ({
                    wch: Math.max(header.length + 2, ...data.map(r => (r[i] ? r[i].toString().length : 0))) + 2
                }));

                //  5. Create and download workbook
                const workbook = XLSX.utils.book_new();
                XLSX.utils.book_append_sheet(workbook, worksheet, "Tasks");
                XLSX.writeFile(workbook, `task-list-${new Date().toISOString().slice(0, 10)}.xlsx`);
            } catch (error) {
                console.error("Error generating Excel:", error);
                alert("Failed to fetch or export task data.");
            }
        });
    </script>



    <style>
        /* Disable text selection */
        body {
            user-select: none;
        }
    </style>

    <script>
        // Disable right-click
        // document.addEventListener('contextmenu', function (e) {
        //     e.preventDefault();
        // });

        // Disable specific key combinations
        document.addEventListener('keydown', function (e) {
            // F12
            if (e.key === "F12") {
                e.preventDefault();
            }
            // Ctrl+Shift+I / Ctrl+Shift+J
            if (e.ctrlKey && e.shiftKey && (e.key.toUpperCase() === 'I' || e.key.toUpperCase() === 'J')) {
                e.preventDefault();
            }
            // Ctrl+U
            if (e.ctrlKey && e.key.toUpperCase() === 'U') {
                e.preventDefault();
            }
        });

        // Disable copy
        document.addEventListener('copy', function (e) {
            e.preventDefault();
        });
    </script>

    <!-- <script>

        // Logic to switch tabs
        document.addEventListener('DOMContentLoaded', function () {
            const tabs = document.querySelectorAll('.tab-link');
            const panels = document.querySelectorAll('.tab-panel');

            // Restore last active tab from localStorage (if any)
            const lastTabId = localStorage.getItem('activeTabId');
            if (lastTabId) {
                const activeTab = document.querySelector(`.tab-link[data-tab="${lastTabId}"]`);
                const activePanel = document.getElementById(lastTabId);
                if (activeTab && activePanel) {
                    // Remove existing active states
                    tabs.forEach(t => {
                        t.classList.remove('active');
                        t.setAttribute('aria-selected', 'false');
                    });
                    panels.forEach(panel => panel.classList.remove('active'));

                    // Set saved tab as active
                    activeTab.classList.add('active');
                    activeTab.setAttribute('aria-selected', 'true');
                    activePanel.classList.add('active');
                }
            }

            tabs.forEach(tab => {
                tab.addEventListener('click', () => {
                    const target = tab.getAttribute('data-tab');

                    // Save clicked tab to localStorage
                    localStorage.setItem('activeTabId', target);

                    // Remove active from all tabs/panels
                    tabs.forEach(t => {
                        t.classList.remove('active');
                        t.setAttribute('aria-selected', 'false');
                    });
                    panels.forEach(panel => panel.classList.remove('active'));

                    // Activate clicked tab/panel
                    tab.classList.add('active');
                    tab.setAttribute('aria-selected', 'true');
                    document.getElementById(target).classList.add('active');
                });
            });
        });
    </script> -->


</body>

</html>