<?php
require_once '../../config/config.php';  // your DB connection
require_once '../../vendor/autoload.php';  // for PhpSpreadsheet
require_once '../../classes/Task.php';  // for PhpSpreadsheet

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Assuming you have a class Timesheet with getMissedTasksLastMonth()
$task = new Task($conn);

$employees = $_GET['employees'] ?? [];
$departments = $_GET['departments'] ?? [];
$repManagers = $_GET['repManagers'] ?? [];
$allowedEmployees = $_GET['allowedEmployees'] ?? [];

// $allowedEmployees = $input['allowedEmployees'] ?? [];
// $employees = $input['employees'] ?? [];
// $departments = $input['departments'] ?? [];
// $managers = $input['managers'] ?? [];
// $status = $input['status'] ?? '';
// $timeline = $input['timeline'] ?? '';
// $customFrom = $input['customFrom'] ?? '';
// $customTo = $input['customTo'] ?? '';

// $page = isset($input['page']) ? (int) $input['page'] : 1;
// $limit = isset($input['limit']) ? (int) $input['limit'] : 25;



$data = $task->getMissedTasksLastMonth($employees, $departments, $repManagers, $allowedEmployees);

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Headers
$headers = ['Date', 'Employee ID', 'Employee Name', 'Email', 'Reporting Manager'];
$sheet->fromArray($headers, NULL, 'A1');

// Data rows
$rowIndex = 2;
foreach ($data as $row) {
    $sheet->setCellValue("A{$rowIndex}", $row['date']);
    $sheet->setCellValue("B{$rowIndex}", $row['emp_id']);
    $sheet->setCellValue("C{$rowIndex}", $row['name']);
    $sheet->setCellValue("D{$rowIndex}", $row['email']);
    $sheet->setCellValue("E{$rowIndex}", $row['rm_name']);
    $rowIndex++;
}

// Style headers
$sheet->getStyle('A1:E1')->getFont()->setBold(true);
$sheet->getColumnDimension('C')->setWidth(25);
$sheet->getColumnDimension('D')->setWidth(30);

// Output file
$filename = "missed_timesheets_last_month_" . date('Y_m') . ".xlsx";

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("Content-Disposition: attachment; filename=\"$filename\"");

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit;
