<?php

require_once '../config/config.php';
require_once '../classes/Task.php';

session_start();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['error' => 'Invalid method']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$emp_ids = $data['emp_ids'] ?? [];

if (empty($emp_ids) || !is_array($emp_ids)) {
    echo json_encode(['error' => 'Invalid or missing employee IDs']);
    exit;
}

$taskObj = new Task($conn);
$response = $taskObj->getLeavesByEmployeeIds($emp_ids);

echo json_encode($response);


// require_once '../config/config.php';
// require_once '../classes/Task.php';

// session_start();
// $emp_id = $_GET['emp_id'] ?? null;

// if (!$emp_id) {
//     echo json_encode(['error' => 'Unauthorized']);
//     exit;
// }

// $taskObj = new Task($conn);
// $data = $taskObj->getLeavesByEmployeeId($emp_id);  // method defined below

// echo json_encode($data);
